/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
  i-net software 1998-2013

*/
namespace Inet.Viewer.Data
{
    /// <summary>
    /// Takes the information coming from the server after a page limit and interprets the answer.
    /// </summary>
    public class PageLimitLoader : Loader
    {
        private bool pageLimitExceeded;

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        protected internal override bool Load(int token)
        {
            if (token == ViewerTokenConstants.TokenPageLimit)
            {
                pageLimitExceeded = ReadBoolean();
                return true;
            }
            else
            {
                return base.Load(token);
            }
        }

        /// <summary>
        /// The answer of the server </summary>
        /// <returns> true, if there is a limit </returns>
        internal virtual bool PageLimitExceeded
        {
            get
            {
                return pageLimitExceeded;
            }
        }
    }

}